/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSaveFileDialog.cpp,v 1.2 1999/09/30 05:00:15 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "CPath.h"
#include "CSaveFileDialog.h"
#include "CWindow.h"

_USING_PGP

// Class CSaveFileDialog member functions

void 
CSaveFileDialog::Choose(
	HWND				parentWnd, 
	CPath&				path, 
	const char			*defaultPath, 
	const char			*title, 
	const char			*filter, 
	const char			*defaultExt, 
	ValidatePathFunc	pfnValidatePath, 
	void				*userVal)
{
	mPfnValidatePath = pfnValidatePath;
	mUserVal = userVal;

	path.Empty();

	CPath	dir;

	if (IsntNull(defaultPath))
	{
		CPath	cDefaultPath(defaultPath);

		cDefaultPath.GetDirPart(dir);
		cDefaultPath.GetFileNamePart(path);
	}

	try
	{
		pgpClearMemory(&mOfn, sizeof(mOfn));

		// BUGBUG! Specifiy OFN_NOCHANGEDIR or Windows will leak a handle
		// to the last browsed-to directory, preventing PGPdisk unmount.

		mOfn.lStructSize		= sizeof(mOfn);
		mOfn.hwndOwner			= parentWnd;
		mOfn.lpstrFilter		= filter;
		mOfn.lpstrFile			= path.GetBuffer(
			PFLConstants::kMaxPathLength);
		mOfn.nMaxFile			= PFLConstants::kMaxPathLength;
		mOfn.lpstrInitialDir	= dir;
		mOfn.lpstrTitle			= title;
		mOfn.Flags				= OFN_EXPLORER | OFN_PATHMUSTEXIST | 
			OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_NOTESTFILECREATE | 
			OFN_NOCHANGEDIR | OFN_ENABLEHOOK;
		mOfn.lpstrDefExt		= defaultExt;
		mOfn.lpfnHook			= SaveDialogHookProc;
		mOfn.lCustData			= reinterpret_cast<long>(this);

		if (!GetSaveFileName(&mOfn))
		{
			CComboError	error;
			error.err = CommDlgExtendedError();

			if (!error.HaveNonPGPError())
				THROW_PGPERROR(kPGPError_UserAbort);
			else
				THROW_ERRORS(kPGPError_Win32WindowOpFailed, error.err);
		}

		path.ReleaseBuffer();
	}
	catch (CComboError&)
	{
		path.ReleaseBuffer();
		throw;
	}
}

UINT 
CSaveFileDialog::SaveDialogHookProcAux(HWND hdlg, LPOFNOTIFY pON)
{
	if (pON->hdr.code == CDN_FILEOK)
	{
		CPath	path	= pON->lpOFN->lpstrFile;

		if (IsntNull(mPfnValidatePath) && !mPfnValidatePath(path, mUserVal))
		{
			CWindow(hdlg).SetWindowLong(DWL_MSGRESULT, 1);
			return 1;
		}
	}

	return 0;
}

UINT 
CALLBACK 
CSaveFileDialog::SaveDialogHookProc(
	HWND	hdlg, 
	UINT	uiMsg, 
	WPARAM	wParam, 
	LPARAM	lParam)
{
	PGPUInt32	result	= 0;

	if (uiMsg == WM_NOTIFY)
	{
		LPNMHDR	pNM	= reinterpret_cast<LPNMHDR>(lParam);

		if (pNM->code == CDN_INITDONE)
		{
			CWindow	childDlg(hdlg);
			CWindow	parentDlg(childDlg.GetParent());

			parentDlg.Center();
		}
		else if (pNM->code == CDN_FILEOK)
		{
			LPOFNOTIFY	pON	= reinterpret_cast<LPOFNOTIFY>(lParam);

			CSaveFileDialog	*pSaveDlg	= reinterpret_cast<
				CSaveFileDialog *>(pON->lpOFN->lCustData);
			pgpAssertAddrValid(pSaveDlg, CSavePGPdiskDialog);

			result = pSaveDlg->SaveDialogHookProcAux(hdlg, pON);
		}
	}

	return result;
}
